(
	-- Bitmap Texture

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"b4321acb-05bf-449c-95f9-4b24240ade4f"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			append res #("UV", mtl.coords) -- UVGenerator

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			-- Disabled (for now) in bump mode, since these parameters do not exist there
			if (context == 0) do (
				-- From "Output" map embedded in the BitmapTexture
				append res #( "invert",			mtl.output.invert)                   
				append res #( "clamp",			mtl.output.clamp )  
				append res #( "rgb_level",		mtl.output.RGB_Level )  
				append res #( "rgb_offset",		mtl.output.RGB_Offset )  
				append res #( "out_amount",		mtl.output.Output_Amount )  
			)

			-- Accessing mtl.bitmap causes an MXS exception if the file cannot be found!!
			try (
				append res #("Bitmap", mtl)

				-- These only exist in a bump context
				if mtl.bitmap != undefined and context == 1 do (
					append res #("udist", 1.0 / mtl.bitmap.width)
					append res #("vdist", 1.0 / mtl.bitmap.height)
				)
			)
			catch (
				-- Do nothing in particular, this is normal
			)

 			res
		)
	)

	AMGData()
)